﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Project.master" AutoEventWireup="true"
    CodeBehind="ProjectLogframe.aspx.cs" Inherits="GUI.Pages.ProjectLogframe" %>
<%@ Register Src="~/Controls/ProjectNavTest.ascx" TagName="ProjectNavigation" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:ProjectNavigation ID="ProjectNavigation" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
     <div class="row">
        <div class="col-md-12 col-sm-12">
        <div class="portlet light bordered light-blue">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_LogicMatrix %>" /> </span>
                    </div>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">

                        <asp:HiddenField runat="server" ID="txtLogframeId"/>
                        <asp:HiddenField runat="server" ID="txtVersion"/>
                        <asp:HiddenField runat="server" ID="txtIsLastVersion"/>
                        <table id="logframe" class="table">
                    	    <tr class="first">
                    	        <th><asp:Label runat="server" ID="lblVersion"></asp:Label> </th>
                    		    <th><asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Name %>" /></th>
                    		    <th><asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, LogMatrix_Indicators %>" /></th>
                    		    <th><asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, LogMatrix_VerificationSource %>" /></th>
                    		    <th><asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, LogMatrix_Assumptions %>" /></th>
                    	    </tr>
                    
                        <tr>
                    	    <td><b><asp:Literal ID="Literal6" runat="server" Text="<%$ Resources:ProjectManagementUI, LogMatrix_GeneralGoal %>" /></b></td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtCommonGoalTitle" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtCommonGoalIndicators" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtCommonGoalVerificationSource" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtCommonGoalAssumptions" runat="server"></asp:TextBox>
                    	    </td>
                        </tr>
                        <tr>
                    	    <td><b><asp:Literal ID="Literal7" runat="server" Text="<%$ Resources:ProjectManagementUI, LogMatrix_SpecificGoal %>" /></b></td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtSpecificGoalTitle" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtSpecificGoalIndicators" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtSpecificGoalVerificationSource" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtSpecificGoalAssumptions" runat="server"></asp:TextBox>
                    	    </td>
                        </tr>
                        <tr>
                    	    <td><b><asp:Literal ID="Literal8" runat="server" Text="<%$ Resources:ProjectManagementUI, LogMatrix_Results %>" /></b></td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtResultTitle" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtResultIndicators" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtResultVerificationSource" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtResultAssumptions" runat="server"></asp:TextBox>
                    	    </td>
                        </tr>
                        <tr>
                    	    <td><b><asp:Literal ID="Literal9" runat="server" Text="<%$ Resources:ProjectManagementUI, LogMatrix_Activities %>" /></b></td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtActivityTitle" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtActivityIndicators" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtActivityVerificationSource" runat="server"></asp:TextBox>
                    	    </td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtActivityAssumptions" runat="server"></asp:TextBox>
                    	    </td>
                        </tr>
                         <tr>
                    	    <td>&nbsp;</td>
                    	    <td>&nbsp;</td>
                    	    <td>&nbsp;</td>
                    	    <td>&nbsp;</td>
                    	    <td>
                    		    <asp:TextBox CssClass="form-control" TextMode="MultiLine" Rows="4" ID="txtAssumptions" runat="server"></asp:TextBox>
                    	    </td>
                        </tr>
                        </table> 

                        <div class="form-actions right">
                                  <asp:Button ID="btnSave" OnClick="BtnSaveClick" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                            runat="server" />
                                  <asp:Button ID="btnNew" OnClick="BtnNewClick" CssClass="btn blue" Text="<%$ Resources:ProjectManagementUI, LogMatrix_NewVersion %>" runat="server" />
                        </div>
                        
                        <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1">
                                <telerik:RadGrid ID="grdLogframeList" runat="server" PageSize="10" AllowFilteringByColumn="true" Skin="Bootstrap" CssClass="kendo-table"
                                    OnItemCommand="grdLogframeList_OnItemCommand" AllowPaging="true" AllowSorting="true"
                                    OnNeedDataSource="grdLogframeList_OnNeedDataSource">
                                    <GroupingSettings CaseSensitive="false" />
                                    <PagerStyle Mode="NextPrevAndNumeric" />
                                    <MasterTableView ShowHeadersWhenNoRecords="true" TableLayout="Auto" ShowFooter="False" CssClass="table table-striped table-hover"
                                        AutoGenerateColumns="False" DataKeyNames="Id">
                                        <Columns>
                                            <telerik:GridBoundColumn UniqueName="VersionColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
                                                SortExpression="Version" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Version %>" DataField="Version" />
                                            <telerik:GridBoundColumn UniqueName="DateCreatedColumn" AutoPostBackOnFilter="true"
                                                CurrentFilterFunction="EqualTo" SortExpression="DateCreated" ShowFilterIcon="false"
                                                HeaderText="<%$ Resources:ProjectManagementUI, LogMatrix_Created %>" DataField="DateCreated" />
                                            <telerik:GridBoundColumn UniqueName="CreatedByColumn" AutoPostBackOnFilter="true"
                                                CurrentFilterFunction="Contains" SortExpression="User.Name" ShowFilterIcon="false"
                                                HeaderText="<%$ Resources:ProjectManagementUI, Common_CreatedBy %>" DataField="User.Name" />
                                            <telerik:GridBoundColumn UniqueName="IsLastVersionColumn" AutoPostBackOnFilter="true"
                                                CurrentFilterFunction="EqualTo" SortExpression="IsLastVersion" ShowFilterIcon="false"
                                                HeaderText="<%$ Resources:ProjectManagementUI, LogMatrix_LastVersion %>" DataField="IsLastVersion" />
                                             <telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" HeaderText="" ButtonCssClass="btn blue"
                                                ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Choose %>"/>
                                            <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderText="" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ButtonCssClass="btn red" ConfirmText="<%$ Resources:ProjectManagementUI, LogFrame_DeactivateConfirm %>"
                                                ConfirmDialogType="RadWindow" ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>" />
                                           
                                        </Columns>
                                    </MasterTableView>
                                </telerik:RadGrid>
                        </telerik:RadAjaxPanel>

                    </div>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
